<?php
// ------------------------------------------------------------------------- //
// Coppermine Photo Gallery 1.3.2                                            //
// ------------------------------------------------------------------------- //
// Copyright (C) 2002,2003 Gregory DEMAR                                     //
// http://www.chezgreg.net/coppermine/                                       //
// ------------------------------------------------------------------------- //
// Updated by the Coppermine Dev Team                                        //
// (http://coppermine.sf.net/team/)                                          //
// see /docs/credits.html for details                                        //
// ------------------------------------------------------------------------- //
// This program is free software; you can redistribute it and/or modify      //
// it under the terms of the GNU General Public License as published by      //
// the Free Software Foundation; either version 2 of the License, or         //
// (at your option) any later version.                                       //
// ------------------------------------------------------------------------- //
// CVS version: $Id: polish.php,v 1.5 2004/07/24 15:04:07 gaugau Exp $
// ------------------------------------------------------------------------- //

// info about translators and translated language
$lang_translation_info = array(
'lang_name_english' => 'Polish', 
'lang_name_native' => 'Polski',
'lang_country_code' => 'pl',
'trans_name'=> 'Jacek Domo',
'trans_email' => 'plusz@plusz.net',
'trans_website' => 'http://www.plusz.net',
'trans_date' => '2004-05-16', 
);

$lang_charset = 'iso-8859-2';
$lang_text_dir = 'ltr'; // ('ltr' for left to right, 'rtl' for right to left)

// shortcuts for Byte, Kilo, Mega
$lang_byte_units = array('Bajtw', 'KB', 'MB');

// Day of weeks and months
$lang_day_of_week = array('Niedziela', 'Poniedziaek', 'Wtorek', 'roda', 'Czwartek', 'Pitek', 'Sobota');
$lang_month = array('Styczenia', 'Lutego', 'Marca', 'Kwietnia', 'Maja', 'Czerwca', 'Lipica', 'Sierpnia', 'Wrzenia', 'Padziernika', 'Listopada', 'Grudnia');

// Some common strings
$lang_yes = 'Tak';
$lang_no  = 'Nie';
$lang_back = 'Wstecz';
$lang_continue = 'Dalej';
$lang_info = 'Informacja';
$lang_error = 'Bd';

// The various date formats
// See http://www.php.net/manual/en/function.strftime.php to define the variable below
$album_date_fmt =   '%d %B %Y';
$lastcom_date_fmt =  '%d/%m/%y @ %H:%M';
$lastup_date_fmt = '%d %B %Y';
$register_date_fmt = '%d %B %Y';
$lasthit_date_fmt = '%B %d %Y at %I:%M %p'; //cpg1.3.0
$comment_date_fmt =  '%B %d %Y at %I:%M %p'; //cpg1.3.0

// For the word censor
$lang_bad_words = array('');

$lang_meta_album_names = array(
  'random' => 'Losowo wybrane pliki', //cpg1.3.0
  'lastup' => 'Ostatnie aktualizacje',
  'lastalb'=> 'Ostatnio aktualizacje albumw', 
  'lastcom' => 'Ostatnio dodane komentarze',
  'topn' => 'Najpopularniejsze',
  'toprated' => 'Najwyej oceniane',
  'lasthits' => 'Ostatnio ogldane',
  'search' => 'Wyniki wyszukiwania', 
  'favpics'=> 'Ulubione pliki' //cpg1.3.0
);

$lang_errors = array(
  'access_denied' => 'Nie masz uprawnie aby oglda t stron.',
  'perm_denied' => 'Nie masz uprawnie aby wykona t operacj.',
  'param_missing' => 'Skrypt zosta wywoany bez wymaganego parametru.',
  'non_exist_ap' => 'Wybrany plik lub album nie istnieje!',
  'quota_exceeded' => 'Przekroczono limit miejsca. <br /><br />Twj przydzia: [quota]K, Twoje pliki uywaj obecnie: [space]K. Dodanie wybranego pliku spowoduje przekroczenie limitu.', //cpg1.3.0
  'gd_file_type_err' => 'Jeli w uyciu jest biblioteka GD, dozwolone formaty zdj to wycznie JPEG i PNG.',
  'invalid_image' => 'Zdjcie ktre przesano nie moe by obsuone przez bibliotek GD.',
  'resize_failed' => 'Nie mona stworzy miniatury lub zdjcia poredniego.',  
  'no_img_to_display' => 'Brak pliku do wywietlenia',
  'non_exist_cat' => 'Wybrana kategoria nie istnieje',
  'orphan_cat' => 'Kategoria nie ma gazi nadrzdnej, uruchom menedera kategorii aby rozwiza ten problem.', //cpg1.3.0
  'directory_ro' => 'Katalog \'%s\' jest zabezpieczony przed zapisem. Pliki nie mog by skasowane.', //cpg1.3.0
  'non_exist_comment' => 'Wybrany komentarz nie istnieje.',
  'pic_in_invalid_album' => 'Plik znajduje si w nieistniejcym albumie (%s)!?', //cpg1.3.0
  'banned' => 'Obecnie Twj dostp do strony zosta zablokowany.',
  'not_with_udb' => 'Wybrana funkcja nie jest dostpna, poniewa jest zintegrowana z oprogramowniem forum. Czynno ktr chcesz wykona nie jest wspierana w tej konfiguracji, bd powinna by obsuona przez oprogramowanie forum.',
  'offline_title' => 'Offline', //cpg1.3.0
  'offline_text' => 'Galeria jest obecnie wyczona - sprbuj ponownie pniej', //cpg1.3.0
  'ecards_empty' => 'Nie ma obecnie adnych zapisw dotyczcych e-kartek. Sprawd, czy wczye logowanie e-kartek w konfiguracji coppermine!', //cpg1.3.0
  'action_failed' => 'Dziaanie nieudane. Coppermine nie moe przetworzy Twojego dania.', //cpg1.3.0
  'no_zip' => 'Biblioteki do obsugi archiww ZIP nie s obecnie dostpne. Skontaktuj si z administratorem Coppermine.', //cpg1.3.0
  'zip_type' => 'Nie masz uprawnie by przesya archiwa ZIP.', //cpg1.3.0
);

$lang_bbcode_help = 'Moesz uy nastpujcych kodw: <li>[b]<b>Bold</b>[/b]</li> <li>[i]<i>Italic</i>[/i]</li> <li>[url=http://yoursite.com/]Url Text[/url]</li> <li>[email]user@domain.com[/email]</li>'; //cpg1.3.0

// ------------------------------------------------------------------------- //
// File theme.php
// ------------------------------------------------------------------------- //
$lang_main_menu = array(
  'alb_list_title' => 'Przejd do listy albumw',
  'alb_list_lnk' => 'Albumy',
  'my_gal_title' => 'Do prywatnej galerii',
  'my_gal_lnk' => 'Moja galeria',
  'my_prof_lnk' => 'Mj profil',
  'adm_mode_title' => 'Przecz w tryb administratora',
  'adm_mode_lnk' => 'Tryb administratora',
  'usr_mode_title' => 'Przecz w tryb uytkownika',
  'usr_mode_lnk' => 'Tryb uytkownika',
  'upload_pic_title' => 'Przesanie pliku do albumu', //cpg1.3.0
  'upload_pic_lnk' => 'Przesanie pliku', //cpg1.3.0
  'register_title' => 'Utwrz konto',
  'register_lnk' => 'Zarejestruj si',
  'login_lnk' => 'Zaloguj',
  'logout_lnk' => 'Wyloguj',
  'lastup_lnk' => 'Ostatnio dodane',
  'lastcom_lnk' => 'Ostatnie komentarze',
  'topn_lnk' => 'Najpopularniejsze',
  'toprated_lnk' => 'Top Lista',
  'search_lnk' => 'Szukaj',
  'fav_lnk' => 'Ulubione',
  'memberlist_title' => 'Poka uytkownikw', //cpg1.3.0
  'memberlist_lnk' => 'Uytkownicy', //cpg1.3.0
   'faq_title' => 'FAQ galerii &quot;Coppermine&quot;', //cpg1.3.0
  'faq_lnk' => 'FAQ', //cpg1.3.0
);
  
$lang_gallery_admin_menu = array(
  'upl_app_lnk' => 'Akceptacja plikw',
  'config_lnk' => 'Konfiguracja',
  'albums_lnk' => 'Albumy',
  'categories_lnk' => 'Kategorie',
  'users_lnk' => 'Uytkownicy',
  'groups_lnk' => 'Grupy',
  'comments_lnk' => 'Przejrzyj komentarze', //cpg1.3.0
  'searchnew_lnk' => 'Wsadowe dodawanie plikw',  //cpg1.3.0
  'util_lnk' => 'Narzdzia administracyjne',  //cpg1.3.0
  'ban_lnk' => 'Banowanie',
  'db_ecard_lnk' => 'Wywietl e-kartki', //cpg1.3.0 
);

$lang_user_admin_menu = array(
  'albmgr_lnk' => 'Tworzenie / porzdkowanie albumw',
  'modifyalb_lnk' => 'Modyfikacja moich albumw',
  'my_prof_lnk' => 'Mj profil',
);

$lang_cat_list = array(
  'category' => 'Kategoria',
  'albums' => 'Albumy',
  'pictures' => 'Pliki', //cpg1.3.0
);

$lang_album_list = array(
  'album_on_page' => 'albumw: %d, stron: %d'
);

$lang_thumb_view = array(
  'date' => 'DATA',
  //Sort by filename and title
  'name' => 'NAZWA PLIKU', 
  'title' => 'TYTU', 
  'sort_da' => 'Sortowanie wg daty rosnco',
  'sort_dd' => 'Sortowanie wg daty malejco',
  'sort_na' => 'Sortowanie wg nazwy rosnco',
  'sort_nd' => 'Sortowanie wg nazwy malejco',
  'sort_ta' => 'Sortowanie wg tytuu rosnco', 
  'sort_td' => 'Sortowanie wg tytuu malejco', 
  'pic_on_page' => 'plikw: %d stron: %d',
  'user_on_page' => 'uytkownikw: %d, stron: %d'
);

$lang_img_nav_bar = array(
  'thumb_title' => 'Wr do widoku miniatur',
  'pic_info_title' => 'Wywietl/ukryj info o pliku',
  'slideshow_title' => 'Pokaz slajdw',
  'ecard_title' => 'Wylij jako e-kartk',
  'ecard_disabled' => 'e-kartki s wyczone',
  'ecard_disabled_msg' => 'Nie masz uprawnie do wysyania e-kartek', //js-alert //cpg1.3.0
  'prev_title' => 'Poprzedni plik', //cpg1.3.0
  'next_title' => 'Nastpny plik', //cpg1.3.0
  'pic_pos' => 'PLIK %s/%s', //cpg1.3.0
);

$lang_rate_pic = array(
  'rate_this_pic' => 'Oce ten plik ', //cpg1.3.0
  'no_votes' => '(Brak gosw)',
  'rating' => '(obecna ocena : %s / 5 gosw: %s)',
  'rubbish' => 'Do niczego',
  'poor' => 'Sabe',
  'fair' => 'Nieze',
  'good' => 'Dobre',
  'excellent' => 'B. dobre',
  'great' => 'Doskonae',
);

// ------------------------------------------------------------------------- //
// File include/exif.inc.php
// ------------------------------------------------------------------------- //

// void

// ------------------------------------------------------------------------- //
// File include/functions.inc.php
// ------------------------------------------------------------------------- //

$lang_cpg_die = array(
  INFORMATION => $lang_info,
  ERROR => $lang_error,
  CRITICAL_ERROR => 'Bd krytyczny',
  'file' => 'Plik: ',
  'line' => 'Linia: ',
);

$lang_display_thumbnails = array(
  'filename' => 'Nazwa pliku: ',
  'filesize' => 'Rozmiar pliku: ',
  'dimensions' => 'Wymiary: ',
  'date_added' => 'Data dodania: ',  //cpg1.3.0
);

$lang_get_pic_data = array(
  'n_comments' => 'komentarzy: %s ',
  'n_views' => 'odson: %s ',
  'n_votes' => '(gosw: %s)'
);

$lang_cpg_debug_output = array(
  'debug_info' => 'Informacje debuggera', //cpg1.3.0
  'select_all' => 'Wybierz wszystko', //cpg1.3.0
  'copy_and_paste_instructions' => 'Aby otrzyma pomoc na forum wsparcia technicznego coppermine, skopiuj i wklej te informacje debuggera do swojego postu. Pamitaj aby zastpi wszelkie hasa cigiem ***, przed zamieszczeniem postu.', //cpg1.3.0
  'phpinfo' => 'wywietl phpinfo', //cpg1.3.0
);

$lang_language_selection = array(
  'reset_language' => 'Domylny jzyk', //cpg1.3.0
  'choose_language' => 'Wybierz swj jzyk', //cpg1.3.0
);

$lang_theme_selection = array(
  'reset_theme' => 'Domylny styl', //cpg1.3.0
  'choose_theme' => 'Wybierz styl', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File include/init.inc.php
// ------------------------------------------------------------------------- //

// void

// ------------------------------------------------------------------------- //
// File include/picmgmt.inc.php
// ------------------------------------------------------------------------- //

// void

// ------------------------------------------------------------------------- //
// File include/smilies.inc.php
// ------------------------------------------------------------------------- //

if (defined('SMILIES_PHP')) $lang_smilies_inc_php = array(
  'Exclamation' => 'Wykrzyknik',
  'Question' => 'Pytanie',
  'Very Happy' => 'Bardzo zadowolony',
  'Smile' => 'Umiechnity',
  'Sad' => 'Smutny',
  'Surprised' => 'Zaskoczony',
  'Shocked' => 'Zszokowany',
  'Confused' => 'Zniesmaczony',
  'Cool' => 'Luzak',
  'Laughing' => 'mieje si',
  'Mad' => 'Wcieky',
  'Razz' => 'Jzorek',
  'Embarassed' => 'Zawstydzony / gafa',
  'Crying or Very sad' => 'Zrozpaczony',
  'Evil or Very Mad' => 'Wcieky do kwadratu',
  'Twisted Evil' => 'Twisted Evil',
  'Rolling Eyes' => 'Przewraca oczami',
  'Wink' => 'Puszcza oczko',
  'Idea' => 'Pomys',
  'Arrow' => 'Strzaka',
  'Neutral' => 'Neutralny',
  'Mr. Green' => 'Mr. Green',
);

// ------------------------------------------------------------------------- //
// File addpic.php
// ------------------------------------------------------------------------- //

// void

// ------------------------------------------------------------------------- //
// File admin.php
// ------------------------------------------------------------------------- //

if (defined('ADMIN_PHP')) $lang_admin_php = array(
  0 => 'Zakoczono prac administratora...',
  1 => 'Przeczanie do trybu administratora...',
);

// ------------------------------------------------------------------------- //
// File albmgr.php
// ------------------------------------------------------------------------- //
if (defined('ALBMGR_PHP')) $lang_albmgr_php = array(
  'alb_need_name' => 'Albumy musz mie nazw !', //js-alert
  'confirm_modifs' => 'Czy na pewno chcesz dokona tych modyfikacji ?', //js-alert
  'no_change' => 'Nie dokonae/a adnej zmiany !', //js-alert
  'new_album' => 'Nowy album',
  'confirm_delete1' => 'Czy na pewno chcesz skasowa ten album ?', //js-alert
  'confirm_delete2' => '\nWszystkie pliki i komentarze ktre zawiera zostan stracone !', //js-alert
  'select_first' => 'Wybierz najpierw album', //js-alert
  'alb_mrg' => 'Meneder albumw',
  'my_gallery' => '* Moja galeria *',
  'no_category' => '* Bez kategorii *',
  'delete' => 'Kasuj',
  'new' => 'Nowy',
  'apply_modifs' => 'Wykonaj modyfikacje',
  'select_category' => 'Wybierz kategori',
);

// ------------------------------------------------------------------------- //
// File catmgr.php
// ------------------------------------------------------------------------- //
if (defined('CATMGR_PHP')) $lang_catmgr_php = array(
  'miss_param' => 'Brak parametrw do operacji \'%s\'!',
  'unknown_cat' => 'Wybrana kategoria nie istnieje w bazie danych',
  'usergal_cat_ro' => 'Galerie uytkownikw nie mog by kasowane!',
  'manage_cat' => 'Zarzdzaj kategoriami',
  'confirm_delete' => 'Czy jeste pewny/a e chcesz SKASOWA t kategori',
  'category' => 'Kategoria',
  'operations' => 'Operacje',
  'move_into' => 'Przesu do',
  'update_create' => 'Uaktualnij / stwrz kategori',
  'parent_cat' => 'Kategoria wyszego rzdu',
  'cat_title' => 'Tytu kategorii',
  'cat_thumb' => 'Miniatrury kategorii', //cpg1.3.0
  'cat_desc' => 'Opis kategorii'
);

// ------------------------------------------------------------------------- //
// File config.php
// ------------------------------------------------------------------------- //

if (defined('CONFIG_PHP')) $lang_config_php = array(
  'title' => 'Konfiguracja',
  'restore_cfg' => 'Przywr ustawienia domylne',
  'save_cfg' => 'Zachowaj now konfiguracj',
  'notes' => 'Notatki',
  'info' => 'Informacja',
  'upd_success' => 'Konfiguracja Coppermine zostaa uaktualniona',
  'restore_success' => 'Konfiguracja Coppermine zostaa przywrcona',
  'name_a' => 'Nazwa rosnco',
  'name_d' => 'Nazwa malejco',
  'title_a' => 'Tytu rosnco', 
  'title_d' => 'Tytu malejco', 
  'date_a' => 'Data rosnco',
  'date_d' => 'Data malejco',
  'th_any' => 'Maksymalne rozmiary',
  'th_ht' => 'Wysoko',
  'th_wd' => 'Szeroko',
  'label' => 'etykieta', //cpg1.3.0
  'item' => 'element', //cpg1.3.0
  'debug_everyone' => 'Wszyscy', //cpg1.3.0
  'debug_admin' => 'Tylko administrator', //cpg1.3.0
  );

if (defined('CONFIG_PHP')) $lang_config_data = array(
  'Ustawienia gwne',
  array('Nazwa galerii', 'gallery_name', 0),
  array('Opis galerii', 'gallery_description', 0),
  array('E-mail administratora galerii', 'gallery_admin_email', 0),
  array('Adresy docelowe dla linku \'Zobacz wicej\' w e-kartkach', 'ecards_more_pic_target', 0),
  array('Galeria jest wyczona', 'offline', 1), //cpg1.3.0
  array('Logowanie e-kartek', 'log_ecards', 1), //cpg1.3.0
  array('Zezwl na ciganie Ulubionych w archiwum ZIP', 'enable_zipdownload', 1), //cpg1.3.0

  'Language, Themes &amp; Charset settings',
  array('Jzyk', 'lang', 5),
  array('Styl galerii', 'theme', 6),
  array('Pokazuj list dostpnych jzykw', 'language_list', 8), //cpg1.3.0
  array('Pokazuj flagi jzykw', 'language_flags', 8), //cpg1.3.0
  array('Pokazuj &quot;reset&quot; przy wyborze jzyka', 'language_reset', 1), //cpg1.3.0
  array('Pokazuj list styli', 'theme_list', 8), //cpg1.3.0
  array('Pokazuj &quot;reset&quot; przy wyborze stylu', 'theme_reset', 1), //cpg1.3.0
  array('Pokazuj FAQ', 'display_faq', 1), //cpg1.3.0
  array('Pokazuj pomoc bbcode', 'show_bbcode_help', 1), //cpg1.3.0
  array('Kodowanie znakw', 'charset', 4), //cpg1.3.0

  'Przegldanie listy albumw',
  array('Szeroko gwnej galerii (piksele lub %)', 'main_table_width', 0),
  array('Ilo kategorii do wywietlenia', 'subcat_level', 0),
  array('Ilo albumw do wywietlenia', 'albums_per_page', 0),
  array('Ilo kolumn w licie albumw', 'album_list_cols', 0),
  array('Rozmiar miniatur w pikselach', 'alb_list_thumb_size', 0),
  array('Zawarto strony gwnej', 'main_page_layout', 0),
  array('Poka miniatur pierwszego poziomu w miniaturach albumu','first_level',1),
 
  'Widok miniatur',
  array('Ilo kolumn na stronie miniatur', 'thumbcols', 0),
  array('Ilo wierszy na stronie miniatur', 'thumbrows', 0),
  array('Maksymalna ilo paskw do wywietlenia', 'max_tabs', 10), //cpg1.3.0
  array('Wywietl opis pliku (oprcz tytuu) poniej miniatury', 'caption_in_thumbview', 1), //cpg1.3.0
  array('Wywietl ilo odson poniej miniatury', 'views_in_thumbview', 1), //cpg1.3.0
  array('Wywietl ilo komentarzy poniej miniatury', 'display_comment_count', 1),
  array('Wywietl przesyajcego poniej miniatury', 'display_uploader', 1), //cpg1.3.0
  array('Domylny porzdek sortowania plikw', 'default_sort_order', 3), //cpg1.3.0
  array('Minimalna ilo gosw niezbdna do umieszczenia pliku w kategorii \'Top Lista\'', 'min_votes_for_rating', 0), //cpg1.3.0

  'Przegldanie obrazw &amp; Ustawienia komentarzy',
  array('Szeroko tabeli wywietlajcej pliki (piksele lub %)', 'picture_table_width', 0), //cpg1.3.0
  array('Domylne pokazywanie informacji o pliku', 'display_pic_info', 1), //cpg1.3.0
  array('Blokowanie sw z "listy zakazanych" w komentarzach', 'filter_bad_words', 1),
  array('Wywietlanie emotikon w komentarzach', 'enable_smilies', 1),
  array('Maksymalna dugo opisu pliku', 'max_img_desc_length', 0),
  array('Maksymalna ilo znakw w sowie', 'max_com_wlength', 0),
  array('Maksymalna ilo linii w komentarzu', 'max_com_lines', 0),
  array('Maksymalna dugo komentarza (znakw)', 'max_com_size', 0),
  array('Poka "pasek filmu" z miniaturami', 'display_film_strip', 1), 
  array('Ilo elementw wywietlanych w "pasku filmu" z miniaturami', 'max_film_strip_items', 0), 
  array('Powiadom administratora o komentarzu', 'email_comment_notification', 1), //cpg1.3.0
  array('Interwa pokazu slajdw (1 sekunda = 1000 milisekund)', 'slideshow_interval', 0), //cpg1.3.0

  'Ustawienia plikw i miniatur', //cpg1.3.0
  array('Jako plikw JPEG', 'jpeg_qual', 0),
  array('Maksymalny rozmiar miniatury <a href="#notice2" class="clickable_option">**</a>', 'thumb_width', 0), //cpg1.3.0
  array('Uyj wymiaru (szeroko, wysoko lub maksymalny widok dla miniatury)<b>**</b>', 'thumb_use', 7),
  array('Twrz zdjcia porednie','make_intermediate',1),
  array('Maksymalna szeroko poredniego zdjcia lub video <a href="#notice2" class="clickable_option">**</a>', 'picture_width', 0), //cpg1.3.0
  array('Maksymalny rozmiar przesyanych plikw (KB)', 'max_upl_size', 0), //cpg1.3.0
  array('Maksymana wysoko lub szeroko przesyanych zdj (w pikselach)', 'max_upl_width_height', 0), //cpg1.3.0

  'Zaawansowane ustawienia plikw i miniatur', //cpg1.3.0
  array('Wywietlanie ikon albumw prywatnych niezalogowanemu uytkownikowi','show_private',1), //cpg1.3.0
  array('Znaki zakazane w nazwach plikw', 'forbiden_fname_char',0), //cpg1.3.0
  //array('Akceptowane rozszerzenia przesyanych zdj', 'allowed_file_extensions',0), //cpg1.3.0
  array('Akceptowalne typy obrazw', 'allowed_img_types',0), //cpg1.3.0
  array('Akceptowalne typy plikw wideo', 'allowed_mov_types',0), //cpg1.3.0
  array('Akceptowalne typy plikw audio', 'allowed_snd_types',0), //cpg1.3.0
  array('Akceptowalne typy dokumentw', 'allowed_doc_types',0), //cpg1.3.0
  array('Metoda skalowania obrazw','thumb_method',2), //cpg1.3.0
  array('cieka dostpu do oprogramowania \'konwertujcego\' ImageMagick (np /usr/bin/X11/)', 'impath', 0), //cpg1.3.0
  //array('Dozwolone nazwy plikw (waciwe dla ImageMagick)', 'allowed_img_types',0), //cpg1.3.0
  array('Komendy linii polece dla ImageMagick', 'im_options', 0), //cpg1.3.0
  array('Czytaj dane EXIF w plikach JPEG', 'read_exif_data', 1), //cpg1.3.0
  array('Czytaj dane IPTC w plikach JPEG', 'read_iptc_data', 1), //cpg1.3.0
  array('Katalog albumw <a href="#notice1" class="clickable_option">*</a>', 'fullpath', 0), //cpg1.3.0
  array('Nazwa katalogu na pliki uytkownikw <a href="#notice1" class="clickable_option">*</a>', 'userpics', 0), //cpg1.3.0
  array('Prefix dla zdj porednich <a href="#notice1" class="clickable_option">*</a>', 'normal_pfx', 0), //cpg1.3.0
  array('Prefix dla miniatur <a href="#notice1" class="clickable_option">*</a>', 'thumb_pfx', 0), //cpg1.3.0
  array('Domylne uprawnienia katalogw', 'default_dir_mode', 0), //cpg1.3.0
  array('Domylne uprawnienia plikw', 'default_file_mode', 0), //cpg1.3.0

  'Ustawienia uytkownikw',
  array('Zezwalanie na rejestracj nowych uytkownikw', 'allow_user_registration', 1),
  array('Rejestracja uytkownika wymaga potwierdzenia e-mail', 'reg_requires_valid_email', 1),
  array('Powiadom administratora o rejestracji e-mailem', 'reg_notify_admin_email', 1), //cpg1.3.0
  array('Zezwalanie posiadania tego samego adresu e-mail przez dwch uytkownikw', 'allow_duplicate_emails_addr', 1),
  array('Uytkownicy mog tworzy albumy prywatne', 'allow_private_albums', 1),
  array('Powiadom administratora o plikach oczekujcych na akceptacj', 'upl_notify_admin_email', 1), //cpg1.3.0
  array('Zezwl na ogldanie listy uytkownikw uytkownikom zarejestrowanym', 'allow_memberlist', 1), //cpg1.3.0
  
  'Nazwy dodatkowych pl do opisu pliku (pozostaw je puste jeeli nie s uywane)',
  array('Nazwa pola 1', 'user_field1_name', 0),
  array('Nazwa pola 2', 'user_field2_name', 0),
  array('Nazwa pola 3', 'user_field3_name', 0),
  array('Nazwa pola 4', 'user_field4_name', 0),

  'Ustawienia cookies',
  array('Nazwa plikw cookie tworzonych przez skrypt (w przypadku integracji bbs, upewnij si, e nazwa rni si od nazw plikw generowanych przez bbs', 'cookie_name', 0),
  array('cieka plikw cookie tworzonych przez skrypt', 'cookie_path', 0),
  
  'Rne ustawienia',
  array('Wcz tryb debugowania', 'debug_mode', 9), //cpg1.3.0
  array('Pokazuj powiadomienia w trybie debugowania', 'debug_notice', 1), //cpg1.3.0

  '<br /><div align="left"><a name="notice1"></a>(*) Pola oznaczone gwiazdk nie mog by zmienione jeeli w bazie danych s ju pliki.<br />
  <a name="notice2"></a>(**) Zmiana tych ustawie dotyczy jedynie nowych plikw dodawanych do bazy, dlatego rekomenduje si nie dokonywanie zmiany, jeeli w galerii znajduj si ju jakie pliki. Zmiana istniejcych plikw moe zosta jednak dokonana przy pomocy &quot;<a href="util.php">narzdzi administracyjnych (zmiana rozmiaru zdj)</a>&quot; znajdujcych si w menu administratora.</div><br />', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File db_ecard.php //cpg1.3.0
// ------------------------------------------------------------------------- //

if (defined('DB_ECARD_PHP')) $lang_db_ecard_php = array(
  'title' => 'Wylij e-kartk', //cpg1.3.0
  'ecard_sender' => 'Nadawca', //cpg1.3.0
  'ecard_recipient' => 'Odbiorca', //cpg1.3.0
  'ecard_date' => 'Data', //cpg1.3.0
  'ecard_display' => 'Wywietl e-kartk', //cpg1.3.0
  'ecard_name' => 'Imi', //cpg1.3.0
  'ecard_email' => 'E-mail', //cpg1.3.0
  'ecard_ip' => 'IP #', //cpg1.3.0
  'ecard_ascending' => 'rosnco', //cpg1.3.0
  'ecard_descending' => 'malejco', //cpg1.3.0
  'ecard_sorted' => 'Sortowane', //cpg1.3.0
  'ecard_by_date' => 'wg daty', //cpg1.3.0
  'ecard_by_sender_name' => 'wg imienia nadawcy', //cpg1.3.0
  'ecard_by_sender_email' => 'wg e-maila nadawcy', //cpg1.3.0
  'ecard_by_sender_ip' => 'wg adresu IP nadawcy', //cpg1.3.0
  'ecard_by_recipient_name' => 'wg nazwy odbiorcy', //cpg1.3.0
  'ecard_by_recipient_email' => 'wg e-maila odbiorcy', //cpg1.3.0
  'ecard_number' => 'wywietlane rekordy: %s - %s z %s', //cpg1.3.0
  'ecard_goto_page' => 'do strony', //cpg1.3.0
  'ecard_records_per_page' => 'Rekordw na stronie', //cpg1.3.0
  'check_all' => 'Wybierz wszystkie', //cpg1.3.0
  'uncheck_all' => 'Wyczy wszystkie', //cpg1.3.0
  'ecards_delete_selected' => 'Skasuj wybrane e-kartki', //cpg1.3.0
  'ecards_delete_confirm' => 'Czy na pewno chcesz skasowa te rekodry? Zaznacz checkbox!', //cpg1.3.0
  'ecards_delete_sure' => 'Chc skasowa', //cpg1.3.0
);


// ------------------------------------------------------------------------- //
// File db_input.php
// ------------------------------------------------------------------------- //

if (defined('DB_INPUT_PHP')) $lang_db_input_php = array(
  'empty_name_or_com' => 'Musisz poda swoje imi i napisa komentarz',
  'com_added' => 'Twj komentarz zosta dodany',
  'alb_need_title' => 'Musisz poda tytu dla albumu!',
  'no_udp_needed' => 'Zmiana nie jest konieczna.',
  'alb_updated' => 'Album zosta uaktualniony',
  'unknown_album' => 'Wybrany album nie istnieje, lub nie masz uprawnie do przesyania',
  'no_pic_uploaded' => 'Plik nie zosta dodany!<br /><br />Jeeli wybrano plik do przesania, sprawd czy serwer na to zezwala...', //cpg1.3.0
  'err_mkdir' => 'Nie udao si utworzy katalogu %s !',
  'dest_dir_ro' => 'Katalog docelowy %s nie moe by zapisany przez skrypt!',
  'err_move' => 'Nie mona przenie %s do %s !',
  'err_fsize_too_large' => 'Plik ktry przesyasz ma zbyt duy rozmiar (maksymalnie dozwolony: %s x %s) !',//cpg1.3.0
  'err_imgsize_too_large' => 'Plik ktry przesyasz ma zbyt duy rozmiar (maksymalnie dozwolony: to %s KB) !',
  'err_invalid_img' => 'Plik ktry przesyasz jest w niedozwolonym formacie!',
  'allowed_img_types' => 'Moesz przesa tylko %s plikw.',
  'err_insert_pic' => 'Plik \'%s\' nie moe zosta wstawiony do albumu ', //cpg1.3.0
  'upload_success' => 'Plik zosta przesany <br /><br />Bdzie widoczny po akceptacji przez administratora.', //cpg1.3.0
  'notify_admin_email_subject' => '%s - powiadomienie o przesaniu pliku', //cpg1.3.0
  'notify_admin_email_body' => 'Uytkownik %s przesa plik, oczekuje on na Twoj aprobat. Odwied %s', //cpg1.3.0
  'info' => 'Informacje',
  'com_added' => 'Dodano komentarz',
  'alb_updated' => 'Uaktualniono album',
  'err_comment_empty' => 'Twj komentarz jest pusty!',
  'err_invalid_fext' => 'Akceptowane s jedynie pliki z nastpujcymi rozszerzeniami: <br /><br />%s.',
  'no_flood' => 'Przykro mi ale jeste/a autorem ostatniego dodanego komentarza<br /><br />Moesz go edytowa aby zmieni tre',
  'redirect_msg' => 'Jeste przekierowywany.<br /><br /><br />Kliknij \'DALEJ\' jeeli strona nie zmieni si automatycznie',
  'upl_success' => 'Plik zosta przesany', //cpg1.3.0
  'email_comment_subject' => 'W galerii Coppermine dodano komentarz', //cpg1.3.0
  'email_comment_body' => 'Dodano komentarz do Twojej galerii zobacz go tutaj', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File delete.php
// ------------------------------------------------------------------------- //

if (defined('DELETE_PHP')) $lang_delete_php = array(
  'caption' => 'Tytu',
  'fs_pic' => 'peny rozmiar',
  'del_success' => 'skasowano',
  'ns_pic' => 'normalny rozmiar',
  'err_del' => 'nie moe by skasowane',
  'thumb_pic' => 'miniatura',
  'comment' => 'komentarz',
  'im_in_alb' => 'zdjcie z albumu',
  'alb_del_success' => 'Skasowano album \'%s\' ',
  'alb_mgr' => 'Meneder albumw',
  'err_invalid_data' => 'Otrzymano niewaciwe dane \'%s\'',
  'create_alb' => 'Tworzenie albumu \'%s\'',
  'update_alb' => 'Uaktualnienie albumu: \'%s\' tytu: \'%s\' index: \'%s\'',
  'del_pic' => 'Kasowanie pliku', //cpg1.3.0
  'del_alb' => 'Kasowanie albumu',
  'del_user' => 'Kasowanie uytkownika',
  'err_unknown_user' => 'Wybrany uytkownik nie istnieje!',
  'comment_deleted' => 'Komentarz zosta dodany',
);

// ------------------------------------------------------------------------- //
// File displayecard.php
// ------------------------------------------------------------------------- //

// Void

// ------------------------------------------------------------------------- //
// File displayimage.php
// ------------------------------------------------------------------------- //

if (defined('DISPLAYIMAGE_PHP')){

$lang_display_image_php = array(
  'confirm_del' => 'Czy na pewno chcesz skasowa ten plik? \\nZostan skasowane rwnie komentarze do niego.', //js-alert //cpg1.3.0
  'del_pic' => 'SKASUJ TEN PLIK', //cpg1.3.0
  'size' => '%s x %s pikseli',
  'views' => '%s razy',
  'slideshow' => 'Pokaz slajdw',
  'stop_slideshow' => 'ZATRZYMAJ POKAZ',
  'view_fs' => 'Kliknij aby zobaczy peny rozmiar',
  'edit_pic' => 'Edytowanie opisu', //cpg1.3.0
  'crop_pic' => 'Kadrowanie i obrt', //cpg1.3.0
);

$lang_picinfo = array(
  'title' =>'Informacja o pliku', //cpg1.3.0
  'Filename' => 'Nazwa pliku',
  'Album name' => 'Nazwa albumu',
  'Rating' => 'Ocena (%s gosw)',
  'Keywords' => 'Sowa kluczowe',
  'File Size' => 'Rozmiar pliku',
  'Dimensions' => 'Wymiary',
  'Displayed' => 'Wywietle',
  'Camera' => 'Aparat fotograficzny',
  'Date taken' => 'Data zrobienia zdjcia',
  'Aperture' => 'Przesona',
  'Exposure time' => 'Czas ekspozycji',
  'Focal length' => 'Ogniskowa',
  'Comment' => 'Komentarz',
  'addFav'=>'Dodaj do Ulubionych', 
  'addFavPhrase'=>'Ulubione', 
  'remFav'=>'Usu z Ulubionych',
  'iptcTitle'=>'Tytu IPTC', //cpg1.3.0
  'iptcCopyright'=>'Copyright IPTC', //cpg1.3.0
  'iptcKeywords'=>'Sowa kluczowe IPTC', //cpg1.3.0
  'iptcCategory'=>'Kategoria IPTC', //cpg1.3.0
  'iptcSubCategories'=>'Podkategorie IPTC', //cpg1.3.0
);

$lang_display_comments = array(
  'OK' => 'OK',
  'edit_title' => 'Edytuj ten komentarz',
  'confirm_delete' => 'Czy na pewno chcesz skasowa ten komentarz ?', //js-alert
   'add_your_comment' => 'Dodaj komentarz',
  'name'=>'Pseudonim', 
  'comment'=>'Komentarz', 
  'your_name' => 'Anonim', 
);

$lang_fullsize_popup = array(
  'click_to_close' => 'Kliknij zdjcie aby zamkn okno', 
);

}

// ------------------------------------------------------------------------- //
// File ecard.php
// ------------------------------------------------------------------------- //

if (defined('ECARDS_PHP') || defined('DISPLAYECARD_PHP')) $lang_ecard_php =array(
  'title' => 'Wylij e-kartk',
  'invalid_email' => '<b>Uwaga!</b> : niepoprawny adres e-mail !',
  'ecard_title' => 'e-kartka od %s dla Ciebie',
  'view_ecard' => 'Jeeli e-kartka nie wywietla si poprawnie, kliknij ten link',
  'view_more_pics' => 'Kliknij ten link aby zobaczy wicej zdj!',
  'send_success' => 'Twoja e-kartka zostaa wysana',
  'send_failed' => 'Niestety, serwer nie moe wysa Twojej e-kartki...',
  'from' => 'Od',
  'your_name' => 'Twoje imi',
  'your_email' => 'Twj adres e-mail',
  'to' => 'Do',
  'rcpt_name' => 'Nazwa odbiorcy',
  'rcpt_email' => 'Adres e-mail odbiorcy',
  'greetings' => 'Temat',
  'message' => 'Wiadomo',
);

// ------------------------------------------------------------------------- //
// File editpics.php
// ------------------------------------------------------------------------- //

if (defined('EDITPICS_PHP')) $lang_editpics_php = array(
  'pic_info' => 'Plik&nbsp;Info', //cpg1.3.0
  'album' => 'Album',
  'title' => 'Tytu',
  'desc' => 'Opis',
  'keywords' => 'Sowa kluczowe',
  'pic_info_str' => '%s &razy; %s - %s KB - %s odson - %s gosw',
  'approve' => 'Akceptuj plik', //cpg1.3.0
  'postpone_app' => 'Odrocz akceptacj',
  'del_pic' => 'Skasuj plik', //cpg1.3.0
  'reset_view_count' => 'Resetuj licznik odson',
  'reset_votes' => 'Resetuj gosowania',
  'del_comm' => 'Skasuj komentarze',
  'upl_approval' => 'Akceptacja zdj',
  'edit_pics' => 'Edytuj zdjcia',
  'see_next' => 'Zobacz nastpne zdjcia',
  'see_prev' => 'Zobacz poprzednie zdjcia',
  'n_pic' => 'zdj: %s',
  'n_of_pic_to_disp' => 'Ilo zdj do wywietlenia',
  'apply' => 'Zastosuj zmiany'
);

if (defined('EDITPICS_PHP')) $lang_editpics_php = array(
  'pic_info' => 'Informacja&nbsp;o pliku', //cpg1.3.0
  'album' => 'Album',
  'title' => 'Tytu',
  'desc' => 'Opis',
  'keywords' => 'Sowa kluczowe',
  'pic_info_str' => '%s &razy; %s - %s KB - %s odson - %s gosw',
  'approve' => 'Akceptuj plik', //cpg1.3.0
  'postpone_app' => 'Odrocz akceptacj',
  'del_pic' => 'Kasuj plik', //cpg1.3.0
  'read_exif' => 'Odczytaj ponownie informacje EXIF', //cpg1.3.0
  'reset_view_count' => 'Kasuj licznik odson',
  'reset_votes' => 'Kasuj gosowania',
  'del_comm' => 'Kasuj komentarze',
  'upl_approval' => 'Akceptacja plikw',
  'edit_pics' => 'Edycja plikw', //cpg1.3.0
  'see_next' => 'Zobacz nastpne pliki', //cpg1.3.0
  'see_prev' => 'Zobacz poprzednie pliki', //cpg1.3.0
  'n_pic' => '%s plikw', //cpg1.3.0
  'n_of_pic_to_disp' => 'Ilo plikw do wywietlenia', //cpg1.3.0
  'apply' => 'Zastosuj zmiany', //cpg1.3.0
  'crop_title' => 'Edytor zdj Coppermine', //cpg1.3.0
  'preview' => 'Podgld', //cpg1.3.0
  'save' => 'Zapisz zdjcie', //cpg1.3.0
  'save_thumb' =>'Zapisz jako miniatur', //cpg1.3.0
  'sel_on_img' =>'Obszar wyboru musi mieci si na zdjciu!', //js-alert //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File faq.php //cpg1.3.0
// ------------------------------------------------------------------------- //

if (defined('FAQ_PHP')) $lang_faq_php = array(
  'faq' => 'Najczciej zadawane pytania', //cpg1.3.0
  'toc' => 'Spis treci', //cpg1.3.0
  'question' => 'Pytanie: ', //cpg1.3.0
  'answer' => 'Odpowied: ', //cpg1.3.0
);

if (defined('FAQ_PHP')) $lang_faq_data = array(
  'Generalne FAQ', //cpg1.3.0
  array('Dlaczego warto si zarejestrowa?', 'Rejestracja moe by wymagana przez administratora serwisu. Zarejestrowanie si daje uytkownikowi dodatkowe moliwoci, takie jak przesyanie wasnych plikw, tworzenie listy ulubionych, ocenianie zdj, zamieszczanie komentarzy itp.', 'allow_user_registration', '0'), //cpg1.3.0
  array('Jak si zarejestrowa?', 'Przejd do sekcji &quot;Rejestracja&quot; i wypenij wymagane pola (ew. take pola opcjonalne).<br />Jeeli Administrator wczy opcj aktywacji przez e-mail, po wypenieniu formularza rejestracji, na podany tam adres pocztowy otrzymasz e-mail zawierajcy instrukcje w jaki sposb aktywowa konto. Aktywacja jest wymagana przed pierwszym zaogowaniem.', 'allow_user_registration', '1'), //cpg1.3.0
  array('Jak si logowa?', 'Przejd do sekcji &quot;Logowanie&quot;, Wprowad swoj nazw uytkownika i haso. Moesz take wybra opcj &quot;Pamitaj mnie&quot; aby nie musia logowa si przy ponownym wejciu na stron.<br /><b>WANE: aby ta funkcja serwisu dziaaa naley wczy obsug plikw cookie i nie kasowa plikw cookie generowanych przez serwis.</b>', 'offline', 0), //cpg1.3.0
  array('Dlaczego nie mog si zalogowa?', 'Czy zarejestrowae si ju i klikne na cze z wysanego do Ciebie e-mail\'a? cze to pozwoli na aktywowanie Twojego konta. W przypadku innych kopotw skontaktuj si z administratorem serwisu.', 'offline', 0), //cpg1.3.0
  array('Co mam zrobi jeeli zapomn hasa?', 'Jeeli serwis udostpnia link &quot;Zapomniaem hasa&quot;, uyj go. W innym wypadku skontaktuj si z administratorem i popro go o nowe haso.', 'offline', 0), //cpg1.3.0
  //array('Co mam zrobi, jeeli zmieni mi si adres e-mail?', 'Zaloguj si i zmie swj e-mail w &quot;Profilu&quot;', 'offline', 0), //cpg1.3.0
  array('Jak zapisa plik do &quot;Moich ulubionych&quot;?', 'Kliknij na pliku, a nastpnie na czu &quot;informacji o zdjciu&quot; (<img src="images/info.gif" width="16" height="16" border="0" alt="Picture information" />); przejd na d i kliknij &quot;Dodaj do ulubionych&quot;.<br />Moliwe, e administrator wczy opcj domylnego pokazywania informacji o pliku.<br />WANE: Naley wczy obsug plikw cookie z tego serwisu i nie kasowa ich.', 'offline', 0), //cpg1.3.0
  array('Jak oceni plik?', 'Kliknij na miniaturze, przejd na d strony i wybierz odpowiedni ocen.', 'offline', 0), //cpg1.3.0
  array('Jak zamieci komentarz do pliku?', 'Kliknij na miniaturze, przejd na d i w odpowiednim polu wpisz komentarz.', 'offline', 0), //cpg1.3.0
  array('Jak przesa plik?', 'Przejd do &quot;Przesyania zdj&quot; i wybierz album do ktrego chcesz przesa plik, kliknij &quot;Przegldaj&quot; znajd plik ktry chcesz przesa, wybierz &quot;Otwrz&quot; (dodaj opis, jeeli chcesz) i kliknij &quot;Przelij&quot;', 'allow_private_albums', 0), //cpg1.3.0
  array('Gdzie mog przesa plik?', 'Pliki mona przesya do jednego z albumw w Twojej Galerii. Administrator moe take zezwoli Ci na przesyanie zdj do albumw w Galerii Gwnej.', 'allow_private_albums', 0), //cpg1.3.0
  array('Jakie pliki mona przesya? W jakiej wielkoci?', 'Typ i rodzaj przesyanych plikw (jpg, png, etc.) okrela administrator serwisu.', 'offline', 0), //cpg1.3.0
  array('Co to jest &quot;Moja Galeria&quot;?', '&quot;Moja Galeria&quot; to prywatna galeria ktr moe zarzdza uytkownik. Moesz tam przesya swoje pliki.', 'allow_private_albums', 0), //cpg1.3.0
  array('W jaki sposb tworzy, kasowa i zmienia nazwy albumw w &quot;Mojej Galerii&quot;?', 'Powiniene przej do &quot;Trybu Administracyjnego&quot;<br />Przejd do &quot;Tworzenie/Porzdkowanie albumw&quot;i kliknij &quot;Nowy&quot;. Zmie domyln nazw &quot;Nowy Album&quot; na wybran przez siebie.<br />Moesz take modyfikowa dowolny album ze swojej galerii.<br />Nastpnie kliknij &quot;Zastosuj zmiany&quot;.', 'allow_private_albums', 0), //cpg1.3.0
  array('W jaki sposb zezwala i odbiera zezwolenia na ogldanie moich albumw?', 'Przejd do &quot;Trybu Administracyjnego&quot;<br />i sekcji &quot;Modyfikuj moje albumy. Na pasku &quot;Aktualizuj Album&quot; wybierz album, ktry chcesz zmodyfikowa. <br />Moesz zmieni jego nazw, opis, miniatur, ustawi zezwolenia na ogldanie i komentowanie/ocenianie jego zawartoci.<br />Nastpnie kliknij &quot;Aktualizuj album&quot;.', 'allow_private_albums', 0), //cpg1.3.0
  array('Co zrobi by mc obejrze galerie innych uytkownikw?', 'Przejd do &quot;Listy Albumw&quot; i wybierz &quot;Galerie uytkownikw&quot;.', 'allow_private_albums', 0), //cpg1.3.0
  array('Co to s pliki cookie?', 'Pliki cookie zawieraj dane tekstowe zapisywane przez stron internetow na Twoim komputerze. <br />Zazwyczaj pozwalaj uytkownikowi opuci stron i wej na ni ponownie bez koniecznoci ponownego logowania.', 'offline', 0), //cpg1.3.0
  array('Skd mog pobra ten program aby umieci go we wasnym serwisie?', 'Galeria Coppermine jest darmow galeri multimediw, rozpowszechnian na licencji GNU GPL. Zawiera rozbudowan funkcjonalno i zostaa przygotowana na rne platformy. Odwied <a href="http://coppermine.sf.net/">stron domow Coppermine</a> by dowiedzie si wicej i cign najnowsz wersj programu.', 'offline', 0), //cpg1.3.0

  'Nawigowanie po stronie', //cpg1.3.0
  array('Co to jest &quot;Lista albumw&quot;?', 'Lista albumw pokazuje ca kategori, w ktrej obecnie si znajdujesz wraz z czami do kadego albumu. Jeeli nie znajdujesz si obecnie w adnej kategorii, lista albumw wywietli ca zawarto galerii wraz z czami do kategorii, ktre zawiera. Miniatury mog by take czami do kategorii..', 'offline', 0), //cpg1.3.0
  array('Czym jest &quot;Moja Galeria&quot;?', 'Opcja ta umoliwia uytkownikowi serwisu tworzenie wasnej galerii, dodawanie, kasowanie i modyfikowanie albumw, oraz przesyanie do nich plikw.', 'allow_private_albums', 0), //cpg1.3.0
  array('Czym rni si &quot;Tryb Administracyjny&quot; od &quot;Trybu uytkownika&quot;?', 'Tryb administracyjny umoliwia zarzdzanie albumami znajdujcymi si w Twojej prywatnej galerii (a take innymi albumami - jeeli zezwoli na to administrator).', 'allow_private_albums', 0), //cpg1.3.0
  array('Co to jest &quot;Przesanie pliku&quot;?', 'To moliwo przesania pliku (jego rodzaj i wielko s okrelone przez administratora) do wybranych albumw', 'allow_private_albums', 0), //cpg1.3.0
  array('Co to s &quot;Ostatnie aktualizacje&quot;?', 'Umoliwiaj przejrzenie ostatnio dodanych do strony plikw.', 'offline', 0), //cpg1.3.0
  array('Co to s &quot;Ostatnie komentarze&quot;?', 'Ta opcja pokazuje ostatnio dodane przez uytkownikw komentarze, oraz pliki ktrych dotycz.', 'offline', 0), //cpg1.3.0
  array('Czym jest opcja What\'s &quot;Najpopularniejsze&quot;?', 'Opcja ta pokazuje najczciej ogldane pliki (dotyczy wszystkich uytkownikw - zarwno tych zalogowanych jak i niezalogowanych).', 'offline', 0), //cpg1.3.0
  array('Co to jest &quot;Top Lista&quot;?', 'Top lista zawiera list najwyej ocenianych plikw wraz z ich redni ocen (np. piciu uytkownikw gosuje z ocen <img src="images/rating3.gif" width="65" height="14" border="0" alt="" />: plikowi zostanie przyznana ocena <img src="images/rating3.gif" width="65" height="14" border="0" alt="" /> ;lub wrd piciu innych uytkownikw kady daje plikowi ocen od 1 do 5 (1,2,3,4,5) co spowoduje przyznanie plikowi redniej oceny <img src="images/rating3.gif" width="65" height="14" border="0" alt="" /> .)<br />Klasyfikacja przedstawia si nastpujco: od <img src="images/rating5.gif" width="65" height="14" border="0" alt="najlepsze" /> (najlepsze) do <img src="images/rating0.gif" width="65" height="14" border="0" alt="najgorsze" /> (najgorsze).', 'offline', 0), //cpg1.3.0
  array('Czym s &quot;Ulubione&quot;?', 'Ta opcja pozwala uytkownikowi przechowywa odnoniki do ulubionych plikw z galerii w pliku cookie zapisywanym przez przegldark.', 'offline', 0), //cpg1.3.0
);



// ------------------------------------------------------------------------- //
// File forgot_passwd.php //cpg1.3.0
// ------------------------------------------------------------------------- //

if (defined('FORGOT_PASSWD_PHP')) $lang_forgot_passwd_php = array(
  'forgot_passwd' => 'Przypomnienie hasa', //cpg1.3.0
  'err_already_logged_in' => 'Jeste ju zalogowany!', //cpg1.3.0
  'enter_username_email' => 'Podaj nazw uytkownika lub adres e-mail', //cpg1.3.0
  'submit' => 'dalej', //cpg1.3.0
  'failed_sending_email' => 'E-mail z przypomnieniem hasa nie moe zosta wysany!', //cpg1.3.0
  'email_sent' => 'E-mail z nazw uytkownika i hasem zosta wysany na adres %s', //cpg1.3.0
  'err_unk_user' => 'Wybrany uytkownik nie istnieje!', //cpg1.3.0
  'passwd_reminder_subject' => '%s - Przypomnienie hasa', //cpg1.3.0
  'passwd_reminder_body' => 'Poprosie o przesanie Twoich danych uytkownika:
Nazwa uytkownika: %s
Haso: %s
Kliknij %s aby si zalogowa.', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File groupmgr.php
// ------------------------------------------------------------------------- //

if (defined('GROUPMGR_PHP')) $lang_groupmgr_php = array(
  'group_name' => 'Nazwa grupy',
  'disk_quota' => 'Miejsce na dane',
  'can_rate' => 'Moe ocenia pliki', //cpg1.3.0
  'can_send_ecards' => 'Moe wysya e-kartki',
  'can_post_com' => 'Moe zamieszcza komentarze',
  'can_upload' => 'Moe przesya pliki', //cpg1.3.0
  'can_have_gallery' => 'Moe mie galeri osobist',
  'apply' => 'Zastosuj zmiany',
  'create_new_group' => 'Stwrz now grup',
  'del_groups' => 'Skasuj zaznaczon grup/y',
  'confirm_del' => 'Uwaga: jeeli skasujesz t grup jej czonkowie zostan przeniesieni do grupy \'Zarejestrowani\'!\n\nKontynuowa?',
  'title' => 'Zarzdzanie grupami',
  'approval_1' => 'Zgoda na pub. upl.(1)',
  'approval_2' => 'Zgoda na priv. upl.(2)',
  'upload_form_config' => 'Konfiguracja formularza przesyania', //cpg1.3.0
  'upload_form_config_values' => array( 'Przesyanie pojedynczych plikw', 'Przesyanie wielu plikw', 'Przesyanie URI', 'Przesyanie ZIP', 'Plik-URI', 'Plik-ZIP', 'URI-ZIP', 'Plik-URI-ZIP'), //cpg1.3.0
  'custom_user_upload'=>'Uytkownik moe wybiera ilo pl do przesyania?', //cpg1.3.0
  'num_file_upload'=>'Maksymalna/dokadna ilo pl przesyania plikw', //cpg1.3.0
  'num_URI_upload'=>'Maksymalna/dokadna ilo pl przesyania URI', //cpg1.3.0
  'note1' => '<b>(1)</b> Przesyanie zdj do albumu publicznego wymaga zgody administratora',
  'note2' => '<b>(2)</b> Przesyanie zdj do albumu uytkownika wymaga zgody administratora',
  'notes' => 'Uwagi'
);

// ------------------------------------------------------------------------- //
// File index.php
// ------------------------------------------------------------------------- //

if (defined('INDEX_PHP')){

$lang_index_php = array(
  'welcome' => 'Witaj !',
);

$lang_album_admin_menu = array(
  'confirm_delete' => 'Czy na pewno chcesz skasowa ten album? \\nZostan skasowane rwnie wszystkie pliki i komentarze.', //js-alert //cpg1.3.0
  'delete' => 'KASUJ',
  'modify' => 'WACIWOCI',
  'edit_pics' => 'EDYCJA PLIKW', //cpg1.3.0
);

$lang_list_categories = array(
  'home' => 'Strona gwna',
  'stat1' => 'pliki: <b>[pictures]</b>, albumy: <b>[albums]</b>, kategorie: <b>[cat]</b>, komentarze: <b>[comments]</b>, odsony: <b>[views]</b>', //cpg1.3.0
  'stat2' => 'pliki: <b>[pictures]</b>, albumy: <b>[albums]</b>, odsony: <b>[views]</b>', //cpg1.3.0
  'xx_s_gallery' => 'galeria %s', //cpg1.3.0
  'stat3' => 'pliki: <b>[pictures]</b>, albumy: <b>[albums]</b>, komentarze: <b>[comments]</b>, odsony: <b>[views]</b>', //cpg1.3.0
);

$lang_list_users = array(
  'user_list' => 'Lista uytkownikw',
  'no_user_gal' => 'Galerie uytkownikw nie istniej lub nie masz do nich dostpu',
  'n_albums' => 'albumw: %s',
  'n_pics' => 'plikw: %s',  //cpg1.3.0
);

$lang_list_albums = array(
  'n_pictures' => 'plikw: %s', //cpg1.3.0
  'last_added' => ', ostatnio dodany: %s',
);

}

// ------------------------------------------------------------------------- //
// File login.php
// ------------------------------------------------------------------------- //

if (defined('LOGIN_PHP')) $lang_login_php = array(
  'login' => 'Logowanie',
  'enter_login_pswd' => 'Podaj nazw uytkownika i haso aby si zalogowa',
  'username' => 'Nazwa uytkownika',
  'password' => 'Haso',
  'remember_me' => 'Pamitaj mnie',
  'welcome' => 'Witaj %s ...',
  'err_login' => '*** Logowanie nieudane, sprbuj ponownie ***',
  'err_already_logged_in' => 'Jeste ju zalogowany/a!',
  'forgot_password_link' => 'Zapomniaem hasa', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File logout.php
// ------------------------------------------------------------------------- //

if (defined('LOGOUT_PHP')) $lang_logout_php = array(
  'logout' => 'Wylogowywanie',
  'bye' => 'Pa pa %s ...',
  'err_not_loged_in' => 'Nie jeste zalogowany/a!',
);

// ------------------------------------------------------------------------- //
// File phpinfo.php //cpg1.3.0
// ------------------------------------------------------------------------- //

if (defined('PHPINFO_PHP')) $lang_phpinfo_php = array(
  'php_info' => 'PHP info', //cpg1.3.0
  'explanation' => 'Dane generowane przez funkcj <a href="http://www.php.net/phpinfo">phpinfo()</a>, wywietlane przez Coppermine (obcinanie wyjcia przy prawym rogu).', //cpg1.3.0
  'no_link' => 'Ogldanie tych informacji przez osoby nieuprawnione moe stanowi zagroenie bezpieczestwa, dlatego te stron t mona oglda tylko po zalogowaniu si jako administrator. Nie moesz poda cza do tej strony innym uytkownikom, nie uzyskaj oni dostpu do strony.', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File modifyalb.php
// ------------------------------------------------------------------------- //
if (defined('MODIFYALB_PHP')) $lang_modifyalb_php = array(
  'upd_alb_n' => 'Uaktualnij album %s',
  'general_settings' => 'Ustawienia oglne',
  'alb_title' => 'Tytu albumu',
  'alb_cat' => 'Kategoria albumu',
  'alb_desc' => 'Opis albumu',
  'alb_thumb' => 'Miniatury',
  'alb_perm' => 'Uprawnienia albumu',
  'can_view' => 'Moe by ogldany przez',
  'can_upload' => 'Gocie mog przesya pliki',
  'can_post_comments' => 'Gocie mog dodawa komentarze',
  'can_rate' => 'Gocie mog ocenia pliki',
  'user_gal' => 'Galeria uytkownika',
  'no_cat' => '* Bez kategorii *',
  'alb_empty' => 'Album jest pusty',
  'last_uploaded' => 'Ostatnio przesane',
  'public_alb' => 'Wszyscy (album publiczny)',
  'me_only' => 'Tylko ja',
  'owner_only' => 'Tylko waciciel albumu: (%s)',
  'groupp_only' => 'Czonkowie grupy: \'%s\'',
  'err_no_alb_to_modify' => 'Nie mona modyfikowa adnego albumu w bazie.',
  'update' => 'Uaktualnij album', //cpg1.3.0
  'notice1' => '(*) w zalenoci od ustawie %sgrupy%',
);

// ------------------------------------------------------------------------- //
// File ratepic.php
// ------------------------------------------------------------------------- //

if (defined('RATEPIC_PHP')) $lang_rate_pic_php = array(
  'already_rated' => 'Niestety, ju oceniae ten plik', //cpg1.3.0
  'rate_ok' => 'Twj gos zosta zarejestrowany',
  'forbidden' => 'Nie moesz ocenia swoich wasnych plikw.', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File register.php & profile.php
// ------------------------------------------------------------------------- //

if (defined('REGISTER_PHP') || defined('PROFILE_PHP')) {

$lang_register_disclamer = <<<EOT
Administratorzy serwisu {SITE_NAME} dokadaj wszelkich stara by usuwa lub zmienia publikowane przez uytkownikw treci oglnie przyjte za obraliwe, amice prawo, lub obsceniczne, jest jednak niemoliwe by przejrze kady post. Dlatego musisz zobowiza si, e wszelkie opinie, materiay i komentarze jakie zamiecisz na stronach serwisu reprezentuj wycznie Twoje pogldy, a nie pogldy osb zarzdzajcych serwisem.<br />
<br />
Niniejszym zobowizujesz si, by nie zamieszcza na stronach serwisu {SITE_NAME} materiaw obraliwych, obscenicznych, wulgarnych, pornograficznych, nawoujcych do uycia przemocy, stanowicych zagroenie dla bezpieczestwa publicznego, oraz innych materiaw, ktrych przedstawienie na stronach serwisu mogoby stanowi zamanie obowizujcego prawa. Przyjmujesz do wiadomoci, e administrator lub moderatorzy serwisu {SITE_NAME} maj prawo do edycji i usuwania dowolnych zamieszczonych przez Ciebie treci niezgodnych z tym regulaminem. Jako uytkownik serwisu zgadzasz si na przechowywanie informacji niezbdnych do obsugi Twojego konta w bazie danych serwisu, oraz otrzymujesz prawo do ich modyfikacji oraz usunicia w dowolnej chwili. W tym celu naley skontaktowa si z administratorem serwisu. Informacje te nie bd przekazywane osobom trzecim bez Twojej zgody, jednake administratorzy serwisu nie mog ponosz odpowiedzialnoci za kradzie tych informacji w wypadku dziaa osb nieuprawnionych.<br />
<br />
Serwis {SITE_NAME} uywa plikw cookie do przechowywania informacji na Twoim komputerze. Su one jedynie do poprawienia komfortu przegldania zawartoci serwisu. Twj adres e-mail jest uywany jedynie do wysyania potwierdze dotyczcych rejestracji w serwisie. <br />
<br />
Kliknicie znajdujcego si poniej przycisku 'Zgadzam si' oznacza zgod na przedstawiony wyej regulamin serwisu.
EOT;


$lang_register_php = array(
  'page_title' => 'Rejestrowanie uytkownika',
  'term_cond' => 'Warunki korzystania z serwisu',
  'i_agree' => 'Zgadzam si',
  'submit' => 'Wykonaj rejestracj',
  'err_user_exists' => 'Nazwa uytkownika ktr wybrae ju istnieje. Wybierz inn',
  'err_password_mismatch' => 'Hasa nie pasuj do siebie. Wpisz je ponownie',
  'err_uname_short' => 'Nazwa uytkownika musi mie co najmniej 2 znaki',
  'err_password_short' => 'Haso musi mie co najmniej 2 znaki',
  'err_uname_pass_diff' => 'Nazwa uytkownika i haso musz si od siebie rni',
  'err_invalid_email' => 'Adres e-mail jest niepoprawny',
  'err_duplicate_email' => 'W bazie jest ju uytkownik o podanym przez Ciebie adresie e-mail',
  'enter_info' => 'Wprowad informacje potrzebne do rejestracji',
  'required_info' => 'Informacje wymagane',
  'optional_info' => 'Informacje opcjonalne',
  'username' => 'Nazwa uytkownika',
  'password' => 'Haso',
  'password_again' => 'Wprowad ponownie haso',
  'email' => 'E-mail',
  'location' => 'Lokalizacja',
  'interests' => 'Zainteresowania',
  'website' => 'Strona domowa',
  'occupation' => 'Zajcie / zawd',
  'error' => 'BD',
  'confirm_email_subject' => '%s - Informacja o rejestracji',
  'information' => 'Informacja',
  'failed_sending_email' => 'E-mail z potwierdzeniem nie moe by wysany!',
  'thank_you' => 'Dzikujemy za rejestracj.<br /><br />Na podany przez Ciebie adres e-mail zosta wysany list z prob o potwierdzenie.',
  'acct_created' => 'Konto zostao utworzone. Moesz ju zalogowa si podajc wybran wczesniej nazw uytkownika, oraz haso',
  'acct_active' => 'Konto jest ju aktywne. Moesz ju zalogowa si podajc wybran wczesniej nazw uytkownika, oraz haso',
  'acct_already_act' => 'Twoje konto zostao ju aktywowane!',
  'acct_act_failed' => 'Te konto nie moe by aktywowane!',
  'err_unk_user' => 'Podany uytkownik nie istnieje!',
  'x_s_profile' => 'profil: %s',
  'group' => 'Grupa',
  'reg_date' => 'Doczy/a',
  'disk_usage' => 'Uyte miejsce',
  'change_pass' => 'Zmie haso',
  'current_pass' => 'Biece haso',
  'new_pass' => 'Nowe haso',
  'new_pass_again' => 'Podaj ponownie nowe haso',
  'err_curr_pass' => 'Biece haso jest niepoprawne',
  'apply_modif' => 'Zastosuj zmiany',
  'change_pass' => 'Zmia moje haso',
  'update_success' => 'Twj profil zosta uaktualniony',
  'pass_chg_success' => 'Twoje haso zostao zmienione',
  'pass_chg_error' => 'Twoje haso nie zostao zmienione',
  'notify_admin_email_subject' => '%s - powiadomienie o rejestracji', //cpg1.3.0
  'notify_admin_email_body' => 'W galerii zarejestrowa si nowy uytkownik o nazwie "%s"', //cpg1.3.0
);

$lang_register_confirm_email = <<<EOT
Dzikujemy za rejestracj w witrynie {SITE_NAME}

Twoja nazwa uytkownika to: "{USER_NAME}"
Twoje haso to: "{PASSWORD}"

Aby aktywowa konto kliknij na poniszy link albo skopiuj go
i wklej do swojej przegldarki internetowej.

{ACT_LINK}

Pozdrowienia,

Zesp strony {SITE_NAME}

EOT;

}

// ------------------------------------------------------------------------- //
// File reviewcom.php
// ------------------------------------------------------------------------- //

if (defined('REVIEWCOM_PHP')) $lang_reviewcom_php = array(
  'title' => 'Przegldaj komentarze',
  'no_comment' => 'Nie ma komentarzy do przegldania',
  'n_comm_del' => 'Skasowano komentarzy: %s',
  'n_comm_disp' => 'Ilo komentarzy do wywietlenia',
  'see_prev' => 'Zobacz poprzednie',
  'see_next' => 'Zobacz nastpne',
  'del_comm' => 'Skasuj wybrane komentarze',
);


// ------------------------------------------------------------------------- //
// File search.php - OK
// ------------------------------------------------------------------------- //

if (defined('SEARCH_PHP')) $lang_search_php = array(
  0 => 'Wyszukiwarka zdj',
);

// ------------------------------------------------------------------------- //
// File searchnew.php
// ------------------------------------------------------------------------- //

if (defined('SEARCHNEW_PHP')) $lang_search_new_php = array(
  'page_title' => 'Szukaj plikw', //cpg1.3.0
  'select_dir' => 'Wybierz katalog',
  'select_dir_msg' => 'Wybrana funkcja umoliwia wsadowe dodawanie do galerii zdj ktre zostay przesane na serwer.<br /><br />Wybierz katalog do ktrego zostay przesane wybrane pliki', //cpg1.3.0
  'no_pic_to_add' => 'Nie ma pliku do dodania', //cpg1.3.0
  'need_one_album' => 'Uycie tej funckji wymaga istnienia przynajmniej jednego albumu do ktrego masz uprawnienia',
  'warning' => 'Uwaga',
  'change_perm' => 'skrypt nie moe zapisywa plikw do wybranego katalogu. Zmie ustawienia na 755 lub 777 zanim sprbujesz doda pliki!', //cpg1.3.0
  'target_album' => '<b>Zapisuje zdjcia do katalogu &quot;</b>%s<b>&quot; </b>%s', //cpg1.3.0
  'folder' => 'Katalog',
  'image' => 'plik',
  'album' => 'Album',
  'result' => 'Wynik',
  'dir_ro' => 'Nie mona zapisa. ',
  'dir_cant_read' => 'Nie mona odczyta. ',
  'insert' => 'Dodawanie nowych plikw do galerii', //cpg1.3.0
  'list_new_pic' => 'Lista nowych plikw', //cpg1.3.0
  'insert_selected' => 'Wstaw wybrane pliki', //cpg1.3.0
  'no_pic_found' => 'Nie znaleziono nowych plikw', //cpg1.3.0
  'be_patient' => 'Prosz o cierpliwo, skrypt potrzebuje czasu na dodanie zdj', //cpg1.3.0
  'no_album' => 'nie wybrano albumu',  //cpg1.3.0
  'notes' =>  '<ul>'.
  '<li><b>OK</b> : oznacza, e zdjcie zostao dodane'.
  '<li><b>DP</b> : oznacza, e zdjcie jest zduplikowane i istnieje ju w bazie'.
  '<li><b>PB</b> : oznacza brak moliwoci dodania pliku. Sprawd swoje uprawnienia do zapisywania katalogw i plikw'.
  '<li><b>NA</b> : oznacza, e nie wybrae albumu do ktrego miayby trafi pliki, kliknij \'<a href="javascript:history.back(1)">tutaj</a>\' i wybierz album. Jeeli nie masz jeszcze albumu, <a href="albmgr.php">utwrz tutaj nowy</a></li>'.
  '<li>Jeeli \'znaki\' OK, DP, PB nie pojawiaj si, kliknij na pliku aby otrzyma komunikat generowany przez PHP'.
  '<li>Jeeli przegldarka nie zaadowaa strony, wcinij klawisz F5 aby j odwiey'.
  '</ul>', //cpg1.3.0
  'select_album' => 'wybierz album', //cpg1.3.0
  'check_all' => 'Zaznacz wszystkie', //cpg1.3.0
  'uncheck_all' => 'Odznacz wszystkie', //cpg1.3.0
);


// ------------------------------------------------------------------------- //
// File thumbnails.php
// ------------------------------------------------------------------------- //

// Void

// ------------------------------------------------------------------------- //
// File banning.php
// ------------------------------------------------------------------------- //

if (defined('BANNING_PHP')) $lang_banning_php = array(
  'title' => 'Banuj Uytkownikw', 
  'user_name' => 'Nazwa uytkownika', 
  'ip_address' => 'Adres IP', 
  'expiry' => 'Aktywny do daty<br>(pusta - na stae)', 
  'edit_ban' => 'Zapisz zmiany', 
  'delete_ban' => 'Kasuj', 
  'add_new' => 'Dodaj nowy ban', 
  'add_ban' => 'Dodaj', 
  'error_user' => 'Nie mona znale takiego uytkownika', //cpg1.3.0
  'error_specify' => 'Musisz okreli nazw uytkownika lub address IP', //cpg1.3.0
  'error_ban_id' => 'Niewaciwy ID!', //cpg1.3.0
  'error_admin_ban' => 'Nie mona banowa samego siebie!', //cpg1.3.0
  'error_server_ban' => 'Chciae zabanowa swj wasny serwer? Hehe, nie mona tego robi...', //cpg1.3.0
  'error_ip_forbidden' => 'Nie mona banowa tego adresu IP - jest nieroute\'owalny!', //cpg1.3.0
  'lookup_ip' => 'Sprawdz adres IP', //cpg1.3.0
  'submit' => 'dalej!', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File upload.php
// ------------------------------------------------------------------------- //

if (defined('UPLOAD_PHP')) $lang_upload_php = array(
  'title' => 'Upload file', //cpg1.3.0
  'custom_title' => 'Spersonalizowany formularz przesyania', //cpg1.3.0
  'cust_instr_1' => 'Moesz wybra wasn liczb pl sucych do przesyania plikw, jednak nie zostanie pokazane ich wicej ni w limicie okrelonym poniej.', //cpg1.3.0
  'cust_instr_2' => 'Personalizacja formularza', //cpg1.3.0
  'cust_instr_3' => 'Ilo pl przesyania: %s', //cpg1.3.0
  'cust_instr_4' => 'Pola przesyania URI/URL: %s', //cpg1.3.0
  'cust_instr_5' => 'Pola przesyania URI/URL:', //cpg1.3.0
  'cust_instr_6' => 'Pola przesyania plikw:', //cpg1.3.0
  'cust_instr_7' => 'Podaj liczb kadego z rodzajw pl przesyania plikw, jakich potrzebujesz. Nastpnie kliknij \'Dalej\'. ', //cpg1.3.0
  'reg_instr_1' => 'Nieudane tworzenie formularza.', //cpg1.3.0
  'reg_instr_2' => 'Moesz przesya pliki przy pomocy poniszych pl. Rozmiar plikw przesyanych na serwer nie moe przekroczy %s KB kady. Pliki ZIP przesane w sekcjach \'Przesanie pliku\' oraz \'Przesanie URI/URL\' pozostan skompresowane.', //cpg1.3.0
  'reg_instr_3' => 'Jeeli chcesz aby spakowane pliki zostay zdekompresowane, uyj pola przesyania plikw w sekcji \'Przesyanie z rozpakowaniem ZIP\'', //cpg1.3.0
  'reg_instr_4' => 'Przy przesyaniu plikw w sekcji Przesyania URI/URL, podaj ca ciek do pliku, np: http://www.mojastrona.com/images/foto.jpg', //cpg1.3.0
  'reg_instr_5' => 'Po uzupenieniu formularza, uyj przycisku \'Dalej\'.', //cpg1.3.0
  'reg_instr_6' => 'Przesyanie z rozpakowaniem ZIP:', //cpg1.3.0
  'reg_instr_7' => 'Przesyanie plikw:', //cpg1.3.0
  'reg_instr_8' => 'Przesyanie URI/URL:', //cpg1.3.0
  'error_report' => 'Raport bdw', //cpg1.3.0
  'error_instr' => 'Wystpiy bdy przy nastpujcych plikach:', //cpg1.3.0
  'file_name_url' => 'Nazwa pliku/URL', //cpg1.3.0
  'error_message' => 'Wiadomo bdu', //cpg1.3.0
  'no_post' => 'Plik nie zosta przesany metod POST.', //cpg1.3.0
  'forb_ext' => 'Zabronione rozszerzenie pliku.', //cpg1.3.0
  'exc_php_ini' => 'Przekroczono wielko plku okrelon w php.ini.', //cpg1.3.0
  'exc_file_size' => 'Przekroczono wielko plku okrelon w konfiguracji CPG.', //cpg1.3.0
  'partial_upload' => 'Udao si tylko czciowo przesa plik.', //cpg1.3.0
  'no_upload' => 'Nie doszo do przesania.', //cpg1.3.0
  'unknown_code' => 'Nieznany bd przesyania PHP.', //cpg1.3.0
  'no_temp_name' => 'Nie udao si przesa pliku ze wzgldu na brak tymczasowej nazwy.', //cpg1.3.0
  'no_file_size' => 'Plik nie zawiera danych lub jest uszkodzony', //cpg1.3.0
  'impossible' => 'Nie mona przenie pliku.', //cpg1.3.0
  'not_image' => 'Plik nie jest obrazem lub jest uszkodzony', //cpg1.3.0
  'not_GD' => 'Brak rozszerzenia GD.', //cpg1.3.0
  'pixel_allowance' => 'Przekroczono rozmiar podany w pikselach.', //cpg1.3.0
  'incorrect_prefix' => 'Niewaciwy prefiks URI/URL', //cpg1.3.0
  'could_not_open_URI' => 'Nie mona otworzy URI.', //cpg1.3.0
  'unsafe_URI' => 'Nie mona potwierdzi bezpieczestwa.', //cpg1.3.0
  'meta_data_failure' => 'Bd metadanych', //cpg1.3.0
  'http_401' => '401 - Brak dostpu', //cpg1.3.0
  'http_402' => '402 - Wymagana opata', //cpg1.3.0
  'http_403' => '403 - Dostp zabroniony', //cpg1.3.0
  'http_404' => '404 - Nie znaleziono', //cpg1.3.0
  'http_500' => '500 - Wewntrzny bd serwera', //cpg1.3.0
  'http_503' => '503 - Usuga niedostpna', //cpg1.3.0
  'MIME_extraction_failure' => 'nie mona okreli MIME.', //cpg1.3.0
  'MIME_type_unknown' => 'Nieznany typ MIME', //cpg1.3.0
  'cant_create_write' => 'Nie mona stworzy/zapisa pliku.', //cpg1.3.0
  'not_writable' => 'Nie mona zapisa do pliku.', //cpg1.3.0
  'cant_read_URI' => 'Nie mona czyta URI/URL', //cpg1.3.0
  'cant_open_write_file' => 'Nie mona otworzy pliku URI do zapisu.', //cpg1.3.0
  'cant_write_write_file' => 'Nie mona zapisa pliku zapisywalnego URI.', //cpg1.3.0
  'cant_unzip' => 'Nie mona zdekompresowa.', //cpg1.3.0
  'unknown' => 'Nieznany bd', //cpg1.3.0
  'succ' => 'Udane przesanie', //cpg1.3.0
  'success' => 'Udane przesanie plikw: %s.', //cpg1.3.0
  'add' => 'Kliknij \'Continue\' by doda pliki do albumw.', //cpg1.3.0
  'failure' => 'Nieudane przesanie', //cpg1.3.0
  'f_info' => 'Informacja o pliku', //cpg1.3.0
  'no_place' => 'Poprzedni plik nie zosta umieszczony w albumie.', //cpg1.3.0
  'yes_place' => 'Poprzedni plik zosta umieszczony w albumie.', //cpg1.3.0
  'max_fsize' => 'Maksymalny rozmiar przesyanego pliku to %s KB',
  'album' => 'Album',
  'picture' => 'Plik', //cpg1.3.0
  'pic_title' => 'Tytu pliku', //cpg1.3.0
  'description' => 'Opis pliku', //cpg1.3.0
  'keywords' => 'Sowa kluczowe (oddzielone spacjami)',
  'err_no_alb_uploadables' => 'Niestety, nie ma albumu do ktrego mgby przesa pliki', //cpg1.3.0
  'place_instr_1' => 'Prosz umieci teraz pliki w albumach. Moesz teraz take wprowadzi stosowne informacje o kadym z plikw.', //cpg1.3.0
  'place_instr_2' => 'S jeszcze pliki wymagajce umieszczenia. Prosz klikn \'Dalej\'.', //cpg1.3.0
  'process_complete' => 'Wszystkie pliki umieszczono w albumach.', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File usermgr.php
// ------------------------------------------------------------------------- //

if (defined('USERMGR_PHP')) $lang_usermgr_php = array(
  'title' => 'Zarzdzanie uytkownikami',
  'name_a' => 'Nazwa rosnco',
  'name_d' => 'Nazwa malejco',
  'group_a' => 'Grupa rosnco',
  'group_d' => 'Grupa malejco',
  'reg_a' => 'Data rej. rosnco',
  'reg_d' => 'Data rej. malejco',
  'pic_a' => 'Liczba plikw rosnco',
  'pic_d' => 'Liczba plikw malejco',
  'disku_a' => 'Uycie dysku rosnco',
  'disku_d' => 'Uycie dysku malejco',
  'lv_a' => 'Ostatnie wizyty rosnco', //cpg1.3.0
  'lv_d' => 'Ostatnie wizyty malejco', //cpg1.3.0
  'sort_by' => 'Posortuj uytkownikw wg',
  'err_no_users' => 'Tabela uytkownikw jest pusta!',
  'err_edit_self' => 'Nie moesz modyfikowa teraz swojego profilu. Aby to zrobi kliknij cze \'Mj profil\'',
  'edit' => 'EDYTUJ',
  'delete' => 'KASUJ',
  'name' => 'Nazwa uytkownika',
  'group' => 'Grupa',
  'inactive' => 'Nieaktywny',
  'operations' => 'Operacje',
  'pictures' => 'Pliki', //cpg1.3.0
   'disk_space' => 'Uyte miejsce / Quota',
  'registered_on' => 'Zerejestrowano',
  'last_visit' => 'Ostatnia wizyta', //cpg1.3.0
  'u_user_on_p_pages' => 'uytkownikw: %d na stronach: %d',
  'confirm_del' => 'Czy na pewno chcesz skasowa tego uytkownika? \\nWszystkie jego pliki i albumy zostan automatycznie skasowane.', //js-alert //cpg1.3.0
  'mail' => 'E-MAIL',
  'err_unknown_user' => 'Selected user does not exist !',
  'modify_user' => 'Modyfikuj uytkownika',
  'notes' => 'Uwagi',
  'note_list' => '<li>Jeeli nie chcesz zmienia swojego ulubionego hasa teraz, zostaw pole "haso" puste',
  'password' => 'Haso',
  'user_active' => 'Uytkownik jest aktywny',
  'user_group' => 'Grupa uytkownikw',
  'user_email' => 'Adres e-mail uytkownika',
  'user_web_site' => 'Strona sieci web uytkownika',
  'create_new_user' => 'Utwrz nowego uytkownika',
  'user_location' => 'Lokacja uytkownika',
  'user_interests' => 'Zainteresowania',
  'user_occupation' => 'Zajcie',
  'latest_upload' => 'Ostatnio przesane', //cpg1.3.0
  'never' => 'brak', //cpg1.3.0
);

// ------------------------------------------------------------------------- //
// File util.php
// ------------------------------------------------------------------------- //

if (defined('UTIL_PHP')) $lang_util_php = array(
  'title' => 'Narzdzia administracyjne (Zmie rozmiar zdj)', //cpg1.3.0
  'what_it_does' => 'Do czego to suy', 
  'what_update_titles' => 'Uaktualnia tytuy nazwami plikw', 
  'what_delete_title' => 'Kasuje tytuy', 
  'what_rebuild' => 'Odbudowuje miniatury i zdjcia porednie', 
  'what_delete_originals' => 'Kasuje zdjcia rdowe, zastpujc je zdjciami o zmienionych wymiarach', 
  'file' => 'Plik', 
  'title_set_to' => 'tytu', 
  'submit_form' => 'przelij', 
  'updated_succesfully' => 'zaktualizowano', 
  'error_create' => 'BD tworzenia', 
  'continue' => 'Przetwarzaj wicej zdj', 
  'main_success' => 'Plik %s zosta ustawiony jako zdjcie gwne', //cpg1.3.0
  'error_rename' => 'Bd przy zmiany nazwy z %s na %s', 
  'error_not_found' => 'Plik %s nie zosta znaleziony', 
  'back' => 'powrt na stron gwn', 
  'thumbs_wait' => 'Uaktualniam miniatury i/lub zdjcia o zmienionych wymiarach, prosz czeka...', 
  'thumbs_continue_wait' => 'Trwa uaktualnianie miniatur i/lub zdj o zmienionych wymiarach...', 
  'titles_wait' => 'Uaktualnianie tytuw, prosz czeka...', 
  'delete_wait' => 'Kasowanie tytuw, prosz czeka...', 
  'replace_wait' => 'Kasowanie oryginaw i zamienianie ich na zdjcia o zmienionych wymiarach..', 
  'instruction' => 'Szybkie instrukcje', 
  'instruction_action' => 'Wybierz akcj', 
  'instruction_parameter' => 'Ustaw parametry', 
  'instruction_album' => 'Wybierz album', 
  'instruction_press' => 'Nacinij %s', 
  'update' => 'Uaktualnij miniatury i/lub zdjcia o zmienionych wymiarach', 
  'update_what' => 'Do uaktualnienia', 
  'update_thumb' => 'Tylko miniatury', 
  'update_pic' => 'Tylko zdjcia o zmienionych wymiarach', 
  'update_both' => 'Zarwno miniatury jak i zdjcia o zmienionych rozmiarach', 
  'update_number' => 'Ilo przetworzonych zdj/kliknicie', 
  'update_option' => '(Sprbuj zmniejszy t ilo, jeeli zaobserwujesz problem z timeoutem)',
  'filename_title' => 'Nazwa pliku &rArr; Tytu pliku', //cpg1.3.0
  'filename_how' => 'Jak modyfikowa nazw pliku', 
  'filename_remove' => 'Usu rozszerzenie .jpg i zamie _ (podkrelenie) na spacje', 
  'filename_euro' => 'Zmienia 2003_11_23_13_20_20.jpg na 23/11/2003 13:20', 
  'filename_us' => 'Zmienia 2003_11_23_13_20_20.jpg na 11/23/2003 13:20',
  'filename_time' => 'Zmienia 2003_11_23_13_20_20.jpg na 13:20',
  'delete' => 'Kasowanie tytuw lub oryginalnych plikw', //cpg1.3.0
  'delete_title' => 'Kasowanie tytuw plikw', //cpg1.3.0
  'delete_original' => 'Skasuj oryginalne zdjcia', 
  'delete_replace' => 'Kasuje oryginalne zdjcia zastpujc je zdjciami zrewymiarowanymi', 
  'select_album' => 'Wybierz album',
  'delete_orphans' => 'Kasuj komentarze do nieistniejcych plikw (dotyczy wszystkich albumw)', //cpg1.3.0
  'orphan_comment' => 'znalezionych komentarzy do nieistniejcych plikw', //cpg1.3.0
  'delete' => 'Kasuj', //cpg1.3.0
  'delete_all' => 'Kasuj wszystko', //cpg1.3.0
  'comment' => 'Komentarz: ', //cpg1.3.0
  'nonexist' => 'doczony do nieistniejcego pliku # ', //cpg1.3.0
  'phpinfo' => 'Wywietl phpinfo', //cpg1.3.0
  'update_db' => 'Aktualizacja bazy danych', //cpg1.3.0
  'update_db_explanation' => 'Jeeli usune pliki coppermine, dodae jak modyfikacj, lub dokonae aktualizacji poprzedniej wersji coppermine, uruchom jednorazowo aktualizacj bazy danych. Stworzy ona niezbdne tabele i/lub ustawienia konfiguracyjne w bazie danych coppermine.', //cpg1.3.0
);

?>